<?php
/*
Plugin Name: Gsdatepicker - Datepicker for input fields
Description: Datepicker for input fields
Version: 1.0.0
Author: George Statis
License: GPL2
*/


add_action('wp_enqueue_scripts', 'gsdatepicker_enqueue_style');
function gsdatepicker_enqueue_style(){
    wp_enqueue_style('gsdatepicker_css', plugin_dir_url(__FILE__) . 'assets/pikaday.css', []);
}

add_action('wp_enqueue_scripts', 'gsdatepicker_enqueue_script');
function gsdatepicker_enqueue_script(){
    wp_enqueue_script('gsmoment_js', plugin_dir_url(__FILE__) . 'assets/moment.min.js', []);
    wp_enqueue_script('gsdatepicker_js', plugin_dir_url(__FILE__) . 'assets/pikaday.js', ['gsmoment_js']);
}

function gsdatepicker_picker_script() {
    ?>
    <style>
        .pika-button{
            border-radius: 0;
        }
    </style>
    <script type="text/javascript">
        
        var fromdate=document.querySelector(".from-date input");
        var todate=document.querySelector(".to-date input");
        
        if(todate){
            todate.setAttribute("autocomplete","off");
            var picker_to = new Pikaday({ 
                field: todate,
                firstDay: 1,
                minDate: new Date(),
                maxDate: new Date(2050, 12, 31),
                yearRange: [2000, 2050],
                format: "DD/MM/YYYY",             
            });
        }
                
        if (fromdate){
            fromdate.setAttribute("autocomplete","off");
            var picker_from = new Pikaday({
                field: fromdate,
                firstDay: 1,
                minDate: new Date(),
                maxDate: new Date(2050, 12, 31),
                yearRange: [2000, 2050],
                
                //bound: false,
                //keyboardInput: false,
                
                format: "DD/MM/YYYY",
                onSelect: function (date) {
                    if(picker_to){
                        var date_to = this.getMoment().add(1, "days").toDate();
                        picker_to.setMinDate(date_to);
                        picker_to.gotoDate(date_to);
                    }
                },
            });
        }

    </script>
    <?php
}
add_action( 'wpforms_wp_footer_end', 'gsdatepicker_picker_script', 10 );